var doc = fl.getDocumentDOM();
var lib = doc.library;
var items = lib.items;



// ---------------------------------------------------------
// CũfBNg\ XML Ŏ擾
// ---------------------------------------------------------
function LibraryGetDirectoryForTree(){
	var ret = "";
	
	ret += "<node label=\"Cu\" data=\"\">";
	var num = items.length;
	for(var i=0;i<num;i++){
		var item = items[i];
		var path = item.name;

		if(!ItemGetDepth(path)){
			if(item.itemType == "folder"){
				var name = ItemGetName(path);
				ret += "<node label=\"" + name + "\" data=\"" + path + "\">";
				ret += _LibraryGetDirectoryForTree(path);
				ret += "</node>";
			}
		}
	}

	ret += "</node>";

	return ret;
}
function _LibraryGetDirectoryForTree(str){
	var ret = "";
	var num = items.length;
	var depth = ItemGetDepth(str);
	for(var i=0;i<num;i++){
		var item = items[i];
		var path = item.name;

		if(path.indexOf(str) >= 0){
			if(depth == (ItemGetDepth(path) - 1)){
				if(item.itemType == "folder"){
					var name = ItemGetName(path);
					ret += "<node label=\"" + name + "\" data=\"" + path + "\">";
					ret += _LibraryGetDirectoryForTree(path);
					ret += "</node>";
				}
			}
		}
	}
	
	return ret;
}


// ---------------------------------------------------------
// CũtH_ XML Ŏ擾
// ---------------------------------------------------------
function LibraryGetItemsForDataGrid(str){
	var ret = "";
	var num = items.length;
	var as_ver = document.asVersion;
	if(!as_ver)	as_ver = 1;

	ret += "<node>";

	// [g
	if(str != ""){
		var depth = ItemGetDepth(str);
		for(var i=0;i<num;i++){
			var item = items[i];
			var path = item.name;

			if(path.indexOf(str) >= 0){
				if(depth == (ItemGetDepth(path) - 1)){
					var name = ItemGetName(path);
					var type = item.itemType;
					if(as_ver <= 2)		var asset = (item.linkageIdentifier == undefined) ? "" : item.linkageIdentifier;
					if(as_ver == 3)		var asset = (item.linkageClassName) ? item.linkageClassName : "";
					ret += "<node ";
					ret += "name=\"" + name + "\" ";
					ret += "type=\"" + type + "\" ";
					ret += "asset=\"" + asset + "\" ";
					ret += "path=\"" + path + "\" ";
					ret += "></node>";
				}
			}
		}
	}else{
		for(i=0;i<num;i++){
			var item = items[i];
			var path = item.name;

			if(!ItemGetDepth(path)){
				var name = ItemGetName(path);
				var type = item.itemType;
				if(as_ver <= 2)		var asset = (item.linkageIdentifier == undefined) ? "" : item.linkageIdentifier;
				if(as_ver == 3)		var asset = (item.linkageClassName) ? item.linkageClassName : "";

				ret += "<node ";
				ret += "name=\"" + name + "\" ";
				ret += "type=\"" + type + "\" ";
				ret += "asset=\"" + asset + "\" ";
				ret += "path=\"" + path + "\" ";
				ret += "></node>";
			}
		}
	}

	ret += "</node>";

	return ret;
}


// ---------------------------------------------------------
// ݂̃^CC̃C[ XML Ŏ擾
// ---------------------------------------------------------
function TimelineGetLayerForDataGrid(){
	var ret = "";
	ret += "<node>";

	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.getTimeline();
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var name = layer.name;
			var type = layer.layerType;

			ret += "<node ";
			ret += "name=\"" + name + "\" ";
			ret += "type=\"" + type + "\" ";
			ret += "></node>";				
		}
	}
	
	ret += "</node>";

	return ret;
}


// ---------------------------------------------------------
// ACeKw̐[𒲂ׂ
// ---------------------------------------------------------
function ItemGetDepth(str){
	var id = 0;
	var num = 0;
	
	while(true){
		id = str.indexOf("/" , id);
		if(id < 0)	break;
		
		num ++;
		id += 1;
	}
	return num;
}


// ---------------------------------------------------------
// ACetH_ȂACe擾
// ---------------------------------------------------------
function ItemGetName(str){
	var start = 0;
	var id = 0;
	var num = 0;
	
	while(true){
		id = str.indexOf("/" , id);
		if(id < 0)	break;
		
		num ++;
		id += 1;
		start = id;
	}
	return str.slice(start, str.length);
}


// ---------------------------------------------------------
// ACepXACeIuWFNg擾
// ---------------------------------------------------------
function GetItem(str){
	var doc = fl.getDocumentDOM();
	if(doc){
		var lib = doc.library;
		var items = lib.items;
		
		for(var i=0;i<items.length;i++){
			var item = items[i];
			if(item.name == str)	return item;
		}
	}
	return null;
}


// ---------------------------------------------------------
// ׂẴV[̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForAllScene(path0,path1){

	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timelines = doc.timelines;
		for(var i=0;i<timelines.length;i++){
			var timeline = timelines[i];
			var layers = timeline.layers;
			for(var j=0;j<layers.length;j++){
				var layer = layers[j];
				var frames = layer.frames;
				for(var k=0;k<frames.length;k++){
					var frame = frames[k];
					var elements = frame.elements;
					for(var l=0;l<elements.length;l++){
						var instance = elements[l];
						if(instance.libraryItem){
							if(instance.libraryItem == item0){
								instance.libraryItem = item1;
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// ׂẴACẽ^CC̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForAllItem(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var lib = doc.library;
		var items = lib.items;
		for(var i=0;i<items.length;i++){
			var item = items[i];
			var timeline = item.timeline;
			if(timeline){
				var layers = timeline.layers;
				for(var j=0;j<layers.length;j++){
					var layer = layers[j];
					var frames = layer.frames;
					for(var k=0;k<frames.length;k++){
						var frame = frames[k];
						var elements = frame.elements;
						for(var l=0;l<elements.length;l++){
							var instance = elements[l];
							if(instance.libraryItem){
								if(instance.libraryItem == item0){
									instance.libraryItem = item1;
								}
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃V[̃^CC̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForSelRootScene(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.timelines[doc.currentTimeline];
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var frames = layer.frames;
			for(var k=0;k<frames.length;k++){
				var frame = frames[k];
				var elements = frame.elements;
				for(var l=0;l<elements.length;l++){
					var instance = elements[l];
					if(instance.libraryItem){
						if(instance.libraryItem == item0){
							instance.libraryItem = item1;
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃ACẽ^CC̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForSelItem(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var lib = doc.library;
		var items = lib.getSelectedItems();
		for(var i=0;i<items.length;i++){
			var item = items[i];
			var timeline = item.timeline;
			if(timeline){
				var layers = timeline.layers;
				for(var j=0;j<layers.length;j++){
					var layer = layers[j];
					var frames = layer.frames;
					for(var k=0;k<frames.length;k++){
						var frame = frames[k];
						var elements = frame.elements;
						for(var l=0;l<elements.length;l++){
							var instance = elements[l];
							if(instance.libraryItem){
								if(instance.libraryItem == item0){
									instance.libraryItem = item1;
								}
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃^CC̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForSelScene(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.getTimeline();
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var frames = layer.frames;
			for(var k=0;k<frames.length;k++){
				var frame = frames[k];
				var elements = frame.elements;
				for(var l=0;l<elements.length;l++){
					var instance = elements[l];
					if(instance.libraryItem){
						if(instance.libraryItem == item0){
							instance.libraryItem = item1;
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃CX^X̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForSelInstance(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var selection = doc.selection;
		for(var i=0;i<selection.length;i++){
			var element = selection[i];
			if(element.libraryItem == item0){
				element.libraryItem = item1;
			}
		}
	}
}


// ---------------------------------------------------------
// obt@zf[^ɕϊ
// ---------------------------------------------------------
function ArrayChangeFromStringBuffer(str){
	var h = 0;
	var layer = new Array();
	while(true){
		if(h >= str.length)	break;
		var len = str.charCodeAt(h);
		h += 1;
		var moji_len = str.substr(h,len);
		h += len;
		moji_len = parseInt(moji_len);
		var moji = str.substr(h,moji_len); 
		h += moji_len;
		
		layer.push(moji);
	}

	return layer;
}


// ---------------------------------------------------------
// z񂩂vf[^邩ׂ
// ---------------------------------------------------------
function ArrayCheckEqualData(ary,str){
	for(var i=0;i<ary.length;i++){
		if(ary[i] == str)	return true;
	}
	
	return false;
}


// ---------------------------------------------------------
// I𒆂̃^CC̃V{CX^Xւ(w肵C[̂)
// ---------------------------------------------------------
function SymbolChangeForSelSceneMaskLayer(path0,path1,str){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var ary = ArrayChangeFromStringBuffer(str);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.getTimeline();
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var frames = layer.frames;
			if(ArrayCheckEqualData(ary,layer.name)){
				for(var k=0;k<frames.length;k++){
					var frame = frames[k];
					var elements = frame.elements;
					for(var l=0;l<elements.length;l++){
						var instance = elements[l];
						if(instance.libraryItem){
							if(instance.libraryItem == item0){
								instance.libraryItem = item1;
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃CX^X̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForSelInstanceMaskLayer(path0,path1,str){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var ary = ArrayChangeFromStringBuffer(str);

	var doc = fl.getDocumentDOM();
	if(doc){
		var selection = doc.selection;
		for(var i=0;i<selection.length;i++){
			var element = selection[i];
			var layer = element.layer;
			if(ArrayCheckEqualData(ary,layer.name)){
				if(element.libraryItem == item0){
					element.libraryItem = item1;
				}
			}
		}
	}
}


// ---------------------------------------------------------
// ׂẴV[̃TEhւ
// ---------------------------------------------------------
function SoundChangeForAllScene(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timelines = doc.timelines;
		for(var i=0;i<timelines.length;i++){
			var timeline = timelines[i];
			var layers = timeline.layers;
			for(var j=0;j<layers.length;j++){
				var layer = layers[j];
				var frames = layer.frames;
				for(var k=0;k<frames.length;k++){
					var frame = frames[k];
					if(frame.soundLibraryItem){
						if(frame.soundLibraryItem == item0){
							frame.soundLibraryItem = item1;
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃V[̃^CC̃TEhւ
// ---------------------------------------------------------
function SoundChangeForSelRootScene(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.timelines[doc.currentTimeline];
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var frames = layer.frames;
			for(var k=0;k<frames.length;k++){
				var frame = frames[k];
				if(frame.soundLibraryItem){
					if(frame.soundLibraryItem == item0){
						frame.soundLibraryItem = item1;
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// ׂẴACẽ^CC̃TEhւ
// ---------------------------------------------------------
function SoundChangeForAllItem(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var lib = doc.library;
		var items = lib.items;
		for(var i=0;i<items.length;i++){
			var item = items[i];
			var timeline = item.timeline;
			if(timeline){
				var layers = timeline.layers;
				for(var j=0;j<layers.length;j++){
					var layer = layers[j];
					var frames = layer.frames;
					for(var k=0;k<frames.length;k++){
						var frame = frames[k];
						if(frame.soundLibraryItem){
							if(frame.soundLibraryItem == item0){
								frame.soundLibraryItem = item1;
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃ACẽ^CC̃TEhւ
// ---------------------------------------------------------
function SoundChangeForSelItem(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var lib = doc.library;
		var items = lib.getSelectedItems();
		for(var i=0;i<items.length;i++){
			var item = items[i];
			var timeline = item.timeline;
			if(timeline){
				var layers = timeline.layers;
				for(var j=0;j<layers.length;j++){
					var layer = layers[j];
					var frames = layer.frames;
					for(var k=0;k<frames.length;k++){
						var frame = frames[k];
						if(frame.soundLibraryItem){
							if(frame.soundLibraryItem == item0){
								frame.soundLibraryItem = item1;
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃^CC̃TEhւ
// ---------------------------------------------------------
function SoundChangeForSelScene(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.getTimeline();
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var frames = layer.frames;
			for(var k=0;k<frames.length;k++){
				var frame = frames[k];
				if(frame.soundLibraryItem){
					if(frame.soundLibraryItem == item0){
						frame.soundLibraryItem = item1;
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// I𒆂̃^CC̃TEhւ(w肵C[̂)
// ---------------------------------------------------------
function SoundChangeForSelSceneMaskLayer(path0,path1,str){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);
	var ary = ArrayChangeFromStringBuffer(str);
	var doc = fl.getDocumentDOM();
	if(doc){
		var timeline = doc.getTimeline();
		var layers = timeline.layers;
		for(var j=0;j<layers.length;j++){
			var layer = layers[j];
			var frames = layer.frames;
			if(ArrayCheckEqualData(ary,layer.name)){
				for(var k=0;k<frames.length;k++){
					var frame = frames[k];
					if(frame.soundLibraryItem){
						if(frame.soundLibraryItem == item0){
							frame.soundLibraryItem = item1;
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// ׂẴXN[̃V{CX^Xւ
// ---------------------------------------------------------
function SymbolChangeForAllScreen(path0,path1){

	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		// XN[x[X̃t@C
		var outline = doc.screenOutline;
		var screens = outline.screens;
		for(var i=0;i<screens.length;i++){
			var screen = screens[i];
			var timeline = screen.timeline;
			var layers = timeline.layers;
			for(var j=0;j<layers.length;j++){
				var layer = layers[j];
				var frames = layer.frames;
				for(var k=0;k<frames.length;k++){
					var frame = frames[k];
					var elements = frame.elements;
					for(var l=0;l<elements.length;l++){
						var instance = elements[l];
						if(instance.libraryItem){
							if(instance.libraryItem == item0){
								instance.libraryItem = item1;
							}
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// ׂẴXN[̃TEhւ
// ---------------------------------------------------------
function SoundChangeForAllScreen(path0,path1){
	var item0 = GetItem(path0);
	var item1 = GetItem(path1);

	var doc = fl.getDocumentDOM();
	if(doc){
		// XN[x[X̃t@C
		var outline = doc.screenOutline;
		var screens = outline.screens;
		for(var i=0;i<screens.length;i++){
			var screen = screens[i];
			var timeline = screen.timeline;
			var layers = timeline.layers;
			for(var j=0;j<layers.length;j++){
				var layer = layers[j];
				var frames = layer.frames;
				for(var k=0;k<frames.length;k++){
					var frame = frames[k];
					if(frame.soundLibraryItem){
						if(frame.soundLibraryItem == item0){
							frame.soundLibraryItem = item1;
						}
					}
				}
			}
		}
	}
}


// ---------------------------------------------------------
// V[̃^Cv擾
// ---------------------------------------------------------
function GetSceneType(){
	var doc = fl.getDocumentDOM();
	if(!doc)	return null;

	var str = fl.version;
	var ver = parseInt(str.substring(str.indexOf(" ")+1, str.indexOf(",")));
	if(ver <= 10){
		if(doc.allowScreens())	return "screen";
	}
	return "scene";
}